/************************************************************************
*              
* COPYRIGHT:   Copyright    2001 Symbol Technologies, Inc. 
*
* FILE:        SymbolEvents.h
*
* SYSTEM:      Symbol Palm Platform.
*
* HEADER:      Symbol Generated Palm Event defines.
*
* DESCRIPTION: defines all Symbol Specific Events.
*
* HISTORY:     03/15/01		Created
*              
*************************************************************************/

#ifndef _Symbol_Events__h_
#define _Symbol_Events__h_

 #ifdef __cplusplus
   extern "C" {
#endif

typedef enum tagSymbolEvent
{
	scanDecodeEvent	= 0x7fff+0x800,			// A decode has finished (valid or invalid decode)
	scanBatteryErrorEvent,					// Battery too low to perform scan
	scanTriggerEvent, 						// A scan attempt was initiated - hard or soft trigger
	s24BatteryErrorEvent,					
    symbolRFUA,								//  DO NOT USE symbolRFUA, reserved for symbol use only
    symbolRFUB,								//  DO NOT USE symbolRFUB, reserved for symbol use only
    symbolRFUC,								//  DO NOT USE symbolRFUC, reserved for symbol use only
    symbolRFUD,								//  DO NOT USE symbolRFUD, reserved for symbol use only
    symbolRFUE,								//  DO NOT USE symbolRFUE, reserved for symbol use only
    symbolRFUF,								//  DO NOT USE symbolRFUF, reserved for symbol use only
    symbolRFUG,								//  DO NOT USE symbolRFUG, reserved for symbol use only
    symbolRFUH,								//  DO NOT USE symbolRFUH, reserved for symbol use only
 
    WanLowBatteryEvent,			//The system has detected that the battery voltage is too low
    							//to operate the WAM radio.  The voltage to the radio has been 
    							//removed.  
    WanBatteryErrorEvent,		//The battery has become dislodged or replaced. 
    							//The voltage to the radio has been removed.     							
    lastSymbolEvent
    
} SymbolEvents;


#ifdef __cplusplus
    }
#endif

#endif
/*******************************************************************
 *              end of file                                        *
 *******************************************************************/
